class RevengeMessage Extends CriticalEventLowPlus;

#exec AUDIO IMPORT FILE="Sounds\Revenge1.wav" NAME="Revenge1"
#exec AUDIO IMPORT FILE="Sounds\Revenge2.wav" NAME="Revenge2"

var localized string revengeMessage;
var localized string generalRevengeMessage;

static function string getString(optional int switch, optional PlayerReplicationInfo pri1,
                                 optional PlayerReplicationInfo pri2, optional Object optionalObject) {
	if (pri2 == none) {
		return default.generalRevengeMessage;
	} else {
		return class'Revenge'.static.format(default.revengeMessage, pri2.playerName);
	}
}

static function clientReceive(PlayerPawn p, optional int switch, optional playerReplicationInfo pri1, optional PlayerReplicationInfo pri2, optional Object optionalObject)
{
local int dice;

	super.clientReceive(p, switch, pri1, pri2, optionalObject);
	
	dice = Rand(2);
	if ( dice == 0 )
		p.clientPlaySound(Sound'Revenge1', , true);
	else
		p.clientPlaySound(Sound'Revenge2', , true);
}

defaultproperties
{
     RevengeMessage="You took sweet revenge on %1!"
     generalRevengeMessage="Revenge!"
     bBeep=False
}
